# app/views/backoffice.py
from flask import Blueprint, render_template
from webapp.models.products import *
from webapp import db
from webapp.views.auth import admin_required

from webapp.config import Config

backoffice = Blueprint("backoffice", __name__)

@backoffice.before_request
def make_session_permanent():
    session.permanent = True
    session.modified = True

@backoffice.teardown_request
def show_teardown(exception):
    db.session.remove()


@backoffice.route("/backoffice/category")
@login_required
def category():
    all_category=Category.query.all()
    return render_template("category.html", all_category=all_category )


